 ; Ŀ
 ;   Horn - Translate text into something a bit more unmistakeable.        
 ;   Copyright 2004 by Rocket Software Ltd.                                
 ;   "Why is that big chicken so dumb?" - Athena.                          
 ; 

 ; Ŀ
 ;   Chcase - see if a character is uppercase, lowercase, punctuation, or  
 ;   a number.                                                             
 ;   Arguments: Chara, a single character string.                          
 ;   Calls nothing.                                                        
 ;   Ignores any characters after the first one.                           
 ;   Returns a string: U, L, P, or N.                                      
 ; 
 (DEFUN CHCASE (chara / chasci)
 ; Ŀ
 ;   Get the decimal ascii number for the character.                       
 ; 
  (setq chasci (ascii chara))
  (cond ((and (>= chasci 48) (<= chasci 57)) "N")
        ((and (>= chasci 65) (<= chasci 90)) "U")
        ((and (>= chasci 97) (<= chasci 122)) "L")
        (T "P")))
 ; Ŀ
 ;   Chcase end.                                                           
 ; 

 ; Ŀ
 ;   Iscase - see if a string is all uppercase, all lower, mixed, or       
 ;   all numbers.                                                          
 ;   Arguments: Str, a string.                                             
 ;   Calls Chcase.                                                         
 ;   Returns a string - Upper, Lower, Mixed, Number, Punctuation - or nil. 
 ; 
 (DEFUN ISCASE (str / pos char typa upper lower number punctu)
  (setq pos 1)
  (while (/= "" (setq char (substr str pos 1)))
         (setq pos (1+ pos))
         (setq typa (chcase char))
         (cond ((= typa "U")   (setq upper T))
               ((= typa "L")   (setq lower T))
               ((= pretyp "N") (setq number T))
               ((= pretyp "P") (setq punctu T))))
  (cond ((and upper lower) "Mixed")
        (upper "Upper")
        (lower "Lower")
        (number "Number")
        (punctu "Punctuation")
        (T ())))
 ; Ŀ
 ;   Iscase end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Leg - Horn attribute prompts in the block tables.          
 ;   Takes no arguments.                                                   
 ;   Returns nothing.                                                      
 ;   Calls Peck.                                                           
 ; 
 (DEFUN LEG (/ reww blokdat first blnam)
  (setq reww T)
  (while (setq blokdat (tblnext "block" reww))
         (setq reww ())
         (setq first (substr (setq blnam (cdr (assoc 2 blokdat))) 1 1))
         (grtext -2 blnam)
         (if (/= first "*")
             (peck (cdr (assoc -2 blokdat)))))
 (princ))
 ; Ŀ
 ;   Subroutine Leg end.                                                   
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
            (setq thestr (strcat thestr sepstr astr)))
            alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Peck - foghorn a prompt string in the block tables.                   
 ;   Takes one argument - the first subentity ename.                       
 ;   Calls nothing, Returns nothing.  Called by Leg.                       
 ; 
 (DEFUN PECK (namm / entt prom1 nup)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (if (setq prom1 (assoc 3 entt))
             (progn
                  (setq nup (horn (cdr prom1)))
                  (entmod (subst (cons 3 nup) prom1 entt))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (princ))
 ; Ŀ
 ;   Peck end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Split - divide a text string at spaces, make into a list   
 ;   of substrings.                                                        
 ; 
 (DEFUN SPLIT (linn / strlst pos len name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) " ")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Split end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Horn - Fog a text string.                                  
 ;   Aruments: str, a string.                                              
 ;   Returns the modified string, or "" if the argument was "".            
 ; 
 (DEFUN HORN (str / typp strlst len firstr first2 lastr lastr2 strmid pref suf)
  (if (= str "")
      (setq strng "")
      (progn
 ; Ŀ
 ;   Call Iscase to see if the string was Upper, Lower, Mixed, Number,     
 ;   Punctuation, or nil (empty).                                          
 ; 
           (setq typp (iscase str))
 ; Ŀ
 ;   Split the string at spaces into a list of strings.                    
 ; 
           (setq strlst (split str))
           (setq len (length strlst))
 ; Ŀ
 ;   Make the prefix and suffix and the required substrings.               
 ; 
           (setq first2 (setq firstr (car strlst)))
           (setq lastr2 (setq lastr (last strlst)))
           (setq strmid (listi (reverse (cdr (reverse (cdr strlst)))) " "))
           (cond ((= typp "Lower")
                  (setq pref ", ah say ")
                  (setq suf ", that is."))
                 ((= typp "Upper")
                  (setq pref ", AH SAY ")
                  (setq suf ", THAT IS."))
                 (T
                  (setq pref ", Ah say ")
                  (setq suf ", that is.")
                  (setq first2 (strcase first2 t))
                  (setq lastr2 (strcat (strcase (substr lastr2 1 1))
                                       (substr lastr2 2)))))
           (if (= (substr lastr2 (strlen lastr2)) ".")
               (setq lastr2 (substr lastr2 1 (1- (strlen lastr2)))))
           (if (/= (substr lastr (strlen lastr)) ".")
               (setq lastr (strcat lastr ".")))
 ; Ŀ
 ;   Decide what to do based on the number of words in the string.         
 ; 
           (cond ((= len 1)
                  (setq strng (strcat firstr pref first2))
                  (if (/= (substr strng (strlen strng)) ".")
                      (setq strng (strcat strng "."))))
                 (T
                  (setq strng (strcat firstr pref first2 " " strmid
                                      (if (= strmid "") "" " ")
                                      lastr "  " lastr2 suf))))))
 ; Ŀ
 ;   Return the modified string.                                           
 ; 
 strng)
 ; Ŀ
 ;   Subroutine Horn end.                                                  
 ; 

 ; Ŀ
 ;   Fog - Chicken Scratch every text entity and attribute in a drawing.   
 ; 
 (DEFUN C:FOG (/ rad ss num enam txt entt pa esub)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 45))
  (setq ss (ssget "x" '((-4 . "<or") (0 . "text") (0 . "mtext") (-4 . "or>"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq txt (horn txt))
         (setq pa (cdr (assoc 10 entt)))
         (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 1)
         (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 1)
         (entmod (subst (cons 1 txt) (assoc 1 entt) entt)))
  (setq num 0)
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (setq num (1+ num))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                (setq txt (cdr (assoc 1 entt)))
                (setq txt (horn txt))
                (setq pa (cdr (assoc 10 entt)))
                (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
                (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 7)
                (entmod (subst (cons 1 txt) (assoc 1 entt) entt))
                (setq esub (entnext esub)))
         (entupd enam))
  (leg)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Horn.                                                                 
 ; 
 (DEFUN C:HORN (/ *error* snapp tex typ e1 relst texlst enam dastr outer)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Erect a local error handler.                                          
 ; 
  (defun *error* (shk / next)
   (if (/= shk "Function cancelled") (write-line shk))
   (setvar "snapmode" snapp)
   (if relst
       (while (setq next (car relst))
              (setq relst (cdr relst))
              (redraw next 4)))
  (princ))
 ; Ŀ
 ;   Error handler locally complete.                                       
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (while (setq tex (nentsel "\nSelect pseudotext: "))
         (setq typ (cdr (assoc 0 (entget (car tex)))))
         (if (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
             (progn
                  (princ (cdr (assoc 1 (setq e1 (entget (car tex))))))
                  (redraw (setq renam (cdr (assoc -1 e1))) 3)
                  (setq relst (cons renam relst))
                  (setq texlst (cons tex texlst)))))
  (if texlst
     (progn
          (while (setq next (car relst))
                 (setq relst (cdr relst))
                 (redraw next 4))
          (while (setq next (car texlst))
                 (setq texlst (cdr texlst))
                 (setq enam (car (setq nent next)))
                 (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                 (if (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
                     (progn
                          (setq outer (car (reverse (car (reverse nent)))))
                          (setq dastr (horn (cdr (setq asoc1 (assoc 1 entt)))))
                          (entmod (subst (cons 1 dastr) asoc1 entt))
                          (entupd enam)
                          (if (= (type outer) 'ENAME) (entupd outer))))))
     (write-line "\nNo suitable entities selected."))
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))

 (princ)